// AObufferDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AObuffer.h"
#include "AObufferDlg.h"
#include<math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAObufferDlg dialog

CAObufferDlg::CAObufferDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAObufferDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAObufferDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAObufferDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAObufferDlg)
	DDX_Control(pDX, IDC_QUIT, m_quitEn);
	DDX_Control(pDX, IDC_STOP, m_stopEn);
	DDX_Control(pDX, IDC_START, m_startEn);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAObufferDlg, CDialog)
	//{{AFX_MSG_MAP(CAObufferDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAObufferDlg message handlers

BOOL CAObufferDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_logicalDevice=0; //Change this if using a different logical device
	m_logicalChannel=0; //Set this to the desired channel
	m_driverInstance=OpenDriverLINX(m_hWnd,""); //Bring up a dialog to select the DriverLINX driver
	/*
		or fill in the driver name to avoid the OpenDriver dialog box
		driver names:
		kdda816 for DDA-08 or DDA-16 boards
		kpci3108 for KPCI-3108
		kpci3100 for KPCI-3116 or KPCI-3110

		m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3108");

		This example is not suitable for KPCI-3130, KPCI-3102 or KPCI-3104 as these boards do not 
		support a paced mode Analog Output.
    */
	m_pSR=(DL_ServiceRequest*) new DL_ServiceRequest;  //create the service request structure
	memset(m_pSR,0,sizeof(DL_ServiceRequest)); //reset the members of the service request to defaults
	DL_SetServiceRequestSize(*m_pSR);

	m_pSR->device=m_logicalDevice;  // which device of the selected driver
	m_pSR->operation=INITIALIZE;    // initialize
	m_pSR->subsystem=DEVICE;        // perform this on all sub-systems of device
	m_pSR->mode=OTHER;              // init has no mode so use OTHER
	m_pSR->hWnd=m_hWnd;             // give a window handle
	DriverLINX(m_pSR); //Execute the service request
	showMessage(m_pSR); //show errors, if any.
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAObufferDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAObufferDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAObufferDlg::showMessage(DL_ServiceRequest* SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
}

void CAObufferDlg::OnQuit() 
{
	// TODO: Add your control notification handler code here
	clearBuffers();
	delete m_pSR;
	m_pSR=NULL;
	CloseDriverLINX(m_driverInstance);
	m_driverInstance=NULL;
	OnOK();
	
}

void CAObufferDlg::OnStart() 
{
	/*This sets up two service requests; one to convert the floating
	point data into native format for the analog output, and the second
	sets up the interrupt analog output service to generate a 100 Hz sine.*/
	
	// TODO: Add your control notification handler code here
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	clearBuffers(); //clear any existing buffers
	float sinebuf[100]; //create an array of float for the sine wave
	int i;
	for(i=0;i<100;i++)
	{
		sinebuf[i]=(float)sin(i*2*3.14159/100);
	}
	m_pSR->operation=CONVERT; //Use the convert operation to translate float into counts
	m_pSR->device=m_logicalDevice;
	m_pSR->subsystem=AO;
	m_pSR->mode=OTHER;
	m_pSR->start.typeEvent=DATACONVERT;
	m_pSR->lpBuffers=(DL_BUFFERLIST*)new BYTE[DL_BufferListBytes(1)]; //Create a buffer list for one buffer
	m_pSR->lpBuffers->nBuffers=1; //Only one buffer will be used
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(m_logicalDevice,AO,m_logicalChannel,100); //allocate enough bytes for 100 samples
	m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_INT,m_pSR->lpBuffers->bufferSize); //allocate one 100 point buffer
	m_pSR->channels.nChannels=1;  //only using one channel
	m_pSR->channels.chanGain[0].channel=m_logicalChannel; // Set the appropriate channel in the channel/gain list
	m_pSR->channels.numberFormat=tNATIVE;
	m_pSR->start.u.dataConvert.startIndex=0; //start at index 0 for the conversion
	m_pSR->start.u.dataConvert.nSamples=100; //Convert 100 samples
	m_pSR->start.u.dataConvert.numberFormat=tSINGLE; //the input buffer is of type float
	m_pSR->start.u.dataConvert.scaling=0.0f; //no scaling will be used
	m_pSR->start.u.dataConvert.offset=0.0f; //no offset will be applied
	m_pSR->start.u.dataConvert.wBuffer=0; //put the converted samples into buffer 0
	m_pSR->start.u.dataConvert.lpBuffer=sinebuf; //use the sinebuf array as the input buffer
	m_pSR->hWnd=m_hWnd;
	DriverLINX(m_pSR); //execute the conversion
	showMessage(m_pSR); //show any errors
	/*
		Now that the data is in the buffer, set up the criterion for writing this
		data to the DAC channel
    */
	//Setup the service request for interrupt analog output
	m_pSR->operation=START;
	m_pSR->device=m_logicalDevice;
	m_pSR->subsystem=AO;
	m_pSR->mode=INTERRUPT;  // could be DMA if board has DMA feature or is PCI board
	m_pSR->start.typeEvent=COMMAND;   // start when we call the DriverLINX() function
	m_pSR->timing.typeEvent=RATEEVENT;  // this will be a paced task
	m_pSR->timing.u.rateEvent.channel=DEFAULTTIMER; //DEFAULTTIMER will pick the appropriate timing channel for a rate event
	m_pSR->timing.u.rateEvent.mode=RATEGEN; //use the rate generator mode to time the waveform
	m_pSR->timing.u.rateEvent.clock=INTERNAL1;  // use internal clock
	m_pSR->timing.u.rateEvent.gate=DISABLED; //don't use gating 
	m_pSR->timing.u.rateEvent.period=Sec2Tics(m_logicalDevice,AO,INTERNAL1,0.01f); //set the period to the number of tics needed for 100 samples per second
	m_pSR->timing.u.rateEvent.pulses=0; //the rate generator will be continuous
	m_pSR->stop.typeEvent=COMMAND; //Stop when a stop operation is carried out
	DriverLINX(m_pSR); //Start the waveform
	showMessage(m_pSR); //show any errors
	m_stopEn.EnableWindow(TRUE); //Enable the stop button, but disable the others to avoid conflicts
	m_startEn.EnableWindow(FALSE);
	m_quitEn.EnableWindow(FALSE);
	UpdateData(FALSE);
}


void CAObufferDlg::clearBuffers()
{
	if(m_pSR!=NULL)
	{
		if(m_pSR->lpBuffers!=NULL)
		{
			if(m_pSR->lpBuffers->BufferAddr[0]!=NULL)
			{
				BufFree(m_pSR->lpBuffers->BufferAddr[0]);
				m_pSR->lpBuffers->BufferAddr[0]=NULL;
			}
			delete(m_pSR->lpBuffers);
			m_pSR->lpBuffers=NULL;
		}
	}
}



void CAObufferDlg::OnStop() 
{
	// TODO: Add your control notification handler code here
	m_pSR->operation=STOP; //Request a stop operation to stop the waveform
	DriverLINX(m_pSR); //Execute the stop request
	showMessage(m_pSR);
	m_stopEn.EnableWindow(FALSE); //enable the other buttons, but disable the stop button
	m_startEn.EnableWindow(TRUE);
	m_quitEn.EnableWindow(TRUE);
	UpdateData(FALSE);
	
}
